
/****** Object:  StoredProcedure [dbo].[Vx_sp_RespondentIncDecQuotaFrequencyAndOnline]    Script Date: 08/25/2016 14:30:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Vx_sp_RespondentIncDecQuotaFrequencyAndOnline]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Vx_sp_RespondentIncDecQuotaFrequencyAndOnline]
GO

/****** Object:  StoredProcedure [dbo].[Vx_sp_RespondentIncDecQuotaFrequencyAndOnline]    Script Date: 08/25/2016 14:30:03 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[Vx_sp_RespondentIncDecQuotaFrequencyAndOnline]
                @projectId  INT,
                @userId     INT,
                @respondent VARCHAR(10),
                @operation  BIT
AS
-- define the operation direction
DECLARE  @CNT INT
IF @operation = 1
SET @CNT = 1
ELSE
SET @CNT = -1


--Update the quotas frequency and online for the specified Respondent
UPDATE Quota
SET    Quota.QtFrequence           = Quota.QtFrequence + (CASE WHEN ResCompleted = 1 AND Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.GlobalPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1)  WHEN ResCompleted = 1 AND Quota.ValidityPeriod = 0 THEN @CNT*COALESCE(IncrementValue,1) ELSE 0 END ), 
	   Quota.FrequencyForThePeriod = Quota.FrequencyForThePeriod + (CASE WHEN ResCompleted = 1 AND Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.BreakdownPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1) ELSE 0 END ),
	   Quota.QtOnline              = Quota.QtOnline    + (@CNT*COALESCE(IncrementValue,1))
FROM   Quota 
		left join  Stratum		WITH(nolock) on StrQuotaId    =  QtQuotaId
		left join  Respondent	WITH(nolock) on ResRespondent =  StrRespondent
WHERE Quota.QtStratum > 0  AND
      Stratum.StrRespondent = @respondent  AND
      Stratum.IncrementValue <> 0


--Update Master Quota frequency
UPDATE Quota
SET    Quota.QtFrequence = Quota.QtFrequence + @CNT
FROM   Quota 
WHERE  QtStratum = 0



-- Update Frequency for Agent (table QuotasAgent) 
UPDATE QuotasAgent
SET    Frequency = Frequency + (@CNT*COALESCE(IncrementValue,1))
FROM   Stratum,  QuotasAgent 
WHERE Stratum.StrQuotaId = QuotasAgent.QuotaId
  AND Stratum.StrRespondent = @respondent 
  AND QuotasAgent.AgentId = @userId 
    IF @CNT = 1
    BEGIN
      -- Define if quota are active
      DECLARE  @UseQuotas BIT
      SET @UseQuotas = (SELECT TOP 1 insvalue FROM   installation WHERE  inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS')
      IF @UseQuotas IS NULL
        SET @UseQuotas = 0
      IF @UseQuotas = 1
        BEGIN
          DECLARE  @NonClosedStrata INT
          --  Create a list of strat to close for this respondent
          SELECT StrQuotaId
          INTO   #closingstrata
          FROM   Stratum
                 INNER JOIN Quota
                   ON quota.QtQuotaId = Stratum.StrQuotaId
                      AND QtQuota > 0
                      AND QtFrequence >= QtQuota
                      AND QtStatus <> 2
          WHERE  StrRespondent = @respondent
                 AND StrStratum > 0
          -- count the amount of strat to close
          SELECT @NonClosedStrata = Count(StrQuotaId) FROM   #closingstrata
          IF @NonClosedStrata > 0
            BEGIN
              -- Call UPdateStrataState 
              EXEC sp_UpdateStrataState  @projectId , @userId
              -- blocked the respondents that are parts of a closed strata
              UPDATE respondent
              SET    resblocked = 1,
                     projectid = @projectId,
                     modifiedby = @userId,
                     modified = Getutcdate()
              WHERE  ResRespondent IN (SELECT StrRespondent
                                       FROM   Stratum
                                       WHERE  StrQuotaId IN (SELECT StrQuotaId
                                                             FROM   #closingstrata))
            END
        END
    END
	

GO

